package com.example.soap;

import com.example.soap.Events;
import com.example.soap.EventsServiceClient;
import databox.ArEventList;
import databox.EnResultOrder;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.ws.Holder;
import junit.framework.TestCase;

public class EventsTest extends TestCase {

    public void testEventList() throws Exception {
        EventsServiceClient client = new EventsServiceClient();
        Events events = client.getEventsPort("http://localhost:8099/SOAP");
        Holder<Integer> countHolder = new Holder<Integer>();
        DatatypeFactory factory = DatatypeFactory.newInstance();
        XMLGregorianCalendar today = factory.newXMLGregorianCalendar(2000, 7, 15, 0, 0, 0, 0, 5*60);
        XMLGregorianCalendar end = factory.newXMLGregorianCalendar(2020, 7, 15, 0, 0, 0, 0, 5*60);
        ArEventList listing = events.findEventList(
                                            "ABC",
                                            today,
                                            end,
                                            "",
                                            Integer.MAX_VALUE,
                                            1,
                                            EnResultOrder.OR_BY_DATE,
                                            false,
                                            countHolder);
        assertTrue("Expected to find some events", (countHolder.value > 0));
    }
}